/* ==================== SongList Controller ==================== */

var songsController = new TKController({
    id: 'songs',
    backButton: '.home',
    highlightedElement: '#track_01',
    trackInterval: null,
    currentTrack:         {
        elem: null,
        index: -1
    },
    isMultiDisc: false,

    // TODO: change the 'to' parameter to the element that you want to navigate to or 'null' for no navigation
    useCustomNav: false,
	SNNavElementSelectors: [
{from: '.track_01', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_01', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_01', to: undefined, direction: KEYBOARD_UP},
{from: '.track_01', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_02', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_02', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_02', to: undefined, direction: KEYBOARD_UP},
{from: '.track_02', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_03', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_03', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_03', to: undefined, direction: KEYBOARD_UP},
{from: '.track_03', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_04', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_04', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_04', to: undefined, direction: KEYBOARD_UP},
{from: '.track_04', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_05', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_05', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_05', to: undefined, direction: KEYBOARD_UP},
{from: '.track_05', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_06', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_06', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_06', to: undefined, direction: KEYBOARD_UP},
{from: '.track_06', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_07', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_07', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_07', to: undefined, direction: KEYBOARD_UP},
{from: '.track_07', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_08', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_08', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_08', to: undefined, direction: KEYBOARD_UP},
{from: '.track_08', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_09', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_09', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_09', to: undefined, direction: KEYBOARD_UP},
{from: '.track_09', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_10', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_10', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_10', to: undefined, direction: KEYBOARD_UP},
{from: '.track_10', to: undefined, direction: KEYBOARD_DOWN},

{from: '.track_11', to: undefined, direction: KEYBOARD_LEFT},
{from: '.track_11', to: undefined, direction: KEYBOARD_RIGHT},
{from: '.track_11', to: undefined, direction: KEYBOARD_UP},
{from: '.track_11', to: undefined, direction: KEYBOARD_DOWN},

]
});

/* ==================== View Management ==================== */

songsController.viewDidLoad = function () {
    var songActions = [];
    for (var i = 0; i < appData.songs.length; i++) {
        var padded_index = (i < 9) ? '0' + (i+1) : (i+1);
        songActions.push({
            selector: '#track_' + padded_index,
            action: 'playSong',
            arguments: [i]
        });
    }
    this.actions = songActions;

    this.SNNavElements = [];
    for (var i = 0; i < this.SNNavElementSelectors.length; i++) {
        var newNavObject = {};
        newNavObject.from = this.view.querySelector(this.SNNavElementSelectors[i].from);
        if (this.SNNavElementSelectors[i].to === undefined) {
            newNavObject.to = undefined;
        }
        else if (this.SNNavElementSelectors[i].to === null) {
            newNavObject.to = null;
        }
        else {
            newNavObject.to = this.view.querySelector(this.SNNavElementSelectors[i].to);
        }
        newNavObject.direction = this.SNNavElementSelectors[i].direction;
        this.SNNavElements.push(newNavObject);
    }
};

songsController.onTrackChange = function( trackIndex ) {
    this.resetCurrentTrack();
    var nextTrack = trackIndex + 1;
    if(nextTrack >= 1 && nextTrack <= appData.songs.length) {
        var idx = (nextTrack < 10) ? '0' + nextTrack : nextTrack;
        var elem = this._view.querySelector("#track_" + idx);
        if(elem != null){
            elem.addClassName('activeImage');
            this.currentTrack.elem = elem;
            this.currentTrack.index = trackIndex;
        }
    }
};

songsController.resetCurrentTrack = function(){
    if(this.currentTrack.elem != null){
        this.currentTrack.elem.removeClassName('activeImage');
        this.currentTrack.elem = null;
        this.currentTrack.index = -1;
    }
};

songsController.playNext = function () {
    this.currentTrack.index++;
    if(this.currentTrack.index > appData.songs.length - 1){
        this.currentTrack.index = 0;
    }
    this.playSong(this.currentTrack.index);
    this.onTrackChange(this.currentTrack.index);
};

songsController.playSong = function (index) {
    bookletController.play(appData.songs[index]);
    this.onTrackChange(this.index);
};

songsController.showSong = function (index) {
    lyricsController.showWithSongAtIndex(index);
};

songsController.startTrackMonitor = function(){
    var _this = this;
    _this.trackMonitor();
    this.trackInterval = setInterval(function(){
        _this.trackMonitor();
    }, 500);
};

songsController.stopTrackMonitor = function(){
    clearInterval(this.trackInterval);
};

songsController.trackMonitor = function(){
    try{
        var track = window.iTunes.currentPlayingTrack;

        if(track != null) {
            var trackIndex = track.trackNumber - 1;
            var discIndex = track.discNumber - 1;

            for (i = 0; i < discIndex; i++) {
				trackIndex += appData.numberOfTracks[i];
			}
//			if(discIndex == 1){
//                trackIndex += appData.numberOfTracks[0];
//            }

            if( trackIndex != this.currentTrack.index ){
                this.onTrackChange(trackIndex);
            }
        }

        if(window.iTunes.currentPlayerState === window.iTunes.StoppedState){
            this.resetCurrentTrack();
        }
    }catch(err) { }
};

songsController.viewWillAppear = function(){
    this.trackMonitor();
    this.startTrackMonitor();
};

songsController.viewDidDisappear = function(){
    this.stopTrackMonitor();
};

songsController.preferredElementToHighlightInDirection = function (currentElement, direction) {
    if (this.useCustomNav) {
        for (var i = 0; i < this.SNNavElements.length; i++) {
            if (currentElement == this.SNNavElements[i].from && direction == this.SNNavElements[i].direction) {
                return this.SNNavElements[i].to;
            }
        }
        return undefined;
    }
    else {
        if (currentElement.hasClassName('song')) {
            var currentIndex;
            var nextIndex;

            if (direction == KEYBOARD_LEFT) {
                return null;
            }
            if (direction == KEYBOARD_RIGHT) {
                return null;
            }
            if (direction == KEYBOARD_UP) {
                currentIndex = currentElement.id.substr(6, 2);
                nextIndex = Number(currentIndex) - 1;
                if (nextIndex < 1) {
                    return null;
                }
                if (nextIndex < 10) nextIndex = '0' + nextIndex;
                //debug(currentIndex + " " + nextIndex);
                return this.view.querySelector('#track_' + nextIndex);
            }
            if (direction == KEYBOARD_DOWN) {
                currentIndex = currentElement.id.substr(6, 2);
                nextIndex = Number(currentIndex) + 1;
                if (nextIndex > appData.songs.length) {
                    return null;
                }
                if (nextIndex < 10) nextIndex = '0' + nextIndex;
                //debug(currentIndex + " " + nextIndex);
                return this.view.querySelector('#track_' + nextIndex);
            }
        }
        return null;
    }
};